// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.verb;

import java.io.ByteArrayInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import java.util.Date;
import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.io.InputStream;
import org.xml.sax.Attributes;
import java.util.Iterator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.XMLReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.helpers.DefaultHandler;

public abstract class HarvesterVerb extends DefaultHandler
{
    public static final String OAI20_NS = "http://www.openarchives.org/OAI/2.0/";
    public static final String OAI20_OAIPMH;
    public static final String OAI20_METADATA;
    public static final String OAI20_ABOUT;
    public static final String OAI20_IDENTIFIER;
    public static final String OAI20_DATESTAMP;
    public static final String OAI20_SETSPEC;
    public static final String OAI20_RECORD;
    public static final String OAI20_SET;
    public static final String OAI20_METADATAFORMAT;
    public static final String OAI20_HEADER;
    public static final String OAI20_ERROR;
    public static final String OAI20_RESPONSE_DATE;
    public static final String OAI20_REQUEST_URL;
    public static final String OAI20_RESUMPTION_TOKEN;
    public static final String OAI20_STATUS;
    private static final boolean debug = false;
    private static int INITIAL_BAOS_SIZE;
    private static HashMap xmlReaders;
    private byte[] responseBuffer;
    private String fullName;
    private String responseDate;
    private String request;
    private boolean errorCapture;
    private String errorCode;
    private StringBuffer errorMessage;
    private ArrayList errors;
    private byte[] response;
    
    public HarvesterVerb() {
        this.responseBuffer = null;
        this.fullName = null;
        this.errorCapture = false;
        this.errorCode = null;
        this.errors = new ArrayList();
        this.response = null;
    }
    
    protected XMLReader getXMLReader() throws SAXException {
        final Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = HarvesterVerb.xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e2) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e3) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e4) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e5) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            HarvesterVerb.xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }
    
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("HarvesterVerb.responseDate: ");
        sb.append(this.responseDate);
        sb.append("\nHarvesterVerb.request: ");
        sb.append(this.request);
        sb.append("\n");
        final Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            sb.append("HarvesterVerb.errors: ");
            sb.append(iterator.next());
            sb.append("\n");
        }
        return sb.toString();
    }
    
    public String getResponseDate() {
        return this.responseDate;
    }
    
    public String getRequestURL() {
        return this.request;
    }
    
    public String getRequest() {
        return this.request;
    }
    
    public byte[] getResponseBuffer() {
        return this.responseBuffer;
    }
    
    public ArrayList getErrors() {
        if (this.errors.size() != 0) {
            return this.errors;
        }
        return null;
    }
    
    public void startElement(final String namespaceURI, final String sName, final String qName, final Attributes attrs) {
        this.fullName = fullName(namespaceURI, sName);
        if (this.fullName.equals(HarvesterVerb.OAI20_ERROR)) {
            this.errorCode = attrs.getValue("code");
            this.errorCapture = true;
            this.errorMessage = new StringBuffer();
        }
    }
    
    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        final String fullName = fullName(namespaceURI, localName);
        if (fullName.equals(HarvesterVerb.OAI20_ERROR)) {
            this.errorCapture = false;
            this.errors.add(new OAIError(this.errorCode, this.errorMessage.toString()));
        }
        this.fullName = null;
    }
    
    public void characters(final char[] buf, final int offset, final int len) {
        if (HarvesterVerb.OAI20_RESPONSE_DATE.equals(this.fullName)) {
            this.responseDate = new String(buf, offset, len);
        }
        else if (HarvesterVerb.OAI20_REQUEST_URL.equals(this.fullName)) {
            this.request = new String(buf, offset, len);
        }
        else if (HarvesterVerb.OAI20_ERROR.equals(this.fullName)) {
            this.errorMessage.append(new String(buf, offset, len));
        }
    }
    
    protected InputStream getResponseStream(final String uri) throws IOException {
        InputStream in = null;
        final URL url = new URL(uri);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/2.0");
            con.setRequestProperty("Accept-Encoding", "compress, gzip, deflate, identify");
            try {
                responseCode = con.getResponseCode();
            }
            catch (FileNotFoundException e) {
                responseCode = 503;
            }
            if (responseCode == 503) {
                long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
                if (retrySeconds == -1L) {
                    final long now = new Date().getTime();
                    final long retryDate = con.getHeaderFieldDate("Retry-After", now);
                    retrySeconds = retryDate - now;
                }
                if (retrySeconds == 0L) {
                    throw new FileNotFoundException("Bad URL?");
                }
                System.err.println("Server response: Retry-After=" + retrySeconds);
                if (retrySeconds <= 0L) {
                    continue;
                }
                try {
                    Thread.sleep(retrySeconds * 1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        } while (responseCode == 503);
        final String contentEncoding = con.getHeaderField("Content-Encoding");
        if ("compress".equals(contentEncoding)) {
            final ZipInputStream zis = new ZipInputStream(con.getInputStream());
            zis.getNextEntry();
            in = zis;
        }
        else if ("gzip".equals(contentEncoding)) {
            in = new GZIPInputStream(con.getInputStream());
        }
        else if ("deflate".equals(contentEncoding)) {
            in = new InflaterInputStream(con.getInputStream());
        }
        else {
            in = con.getInputStream();
        }
        return this.captureResponse(in);
    }
    
    private InputStream captureResponse(final InputStream in) throws IOException {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(HarvesterVerb.INITIAL_BAOS_SIZE);
        final byte[] buffer = new byte[HarvesterVerb.INITIAL_BAOS_SIZE];
        int count = 0;
        final BufferedInputStream bis = new BufferedInputStream(in);
        while ((count = bis.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        this.responseBuffer = baos.toByteArray();
        return new ByteArrayInputStream(this.responseBuffer);
    }
    
    public static String fullName(final String namespaceURI, final String localName) {
        final StringBuffer sb = new StringBuffer();
        sb.append(namespaceURI);
        sb.append("#");
        sb.append(localName);
        return sb.toString();
    }
    
    static {
        OAI20_OAIPMH = fullName("http://www.openarchives.org/OAI/2.0/", "OAI-PMH");
        OAI20_METADATA = fullName("http://www.openarchives.org/OAI/2.0/", "metadata");
        OAI20_ABOUT = fullName("http://www.openarchives.org/OAI/2.0/", "about");
        OAI20_IDENTIFIER = fullName("http://www.openarchives.org/OAI/2.0/", "identifier");
        OAI20_DATESTAMP = fullName("http://www.openarchives.org/OAI/2.0/", "datestamp");
        OAI20_SETSPEC = fullName("http://www.openarchives.org/OAI/2.0/", "setSpec");
        OAI20_RECORD = fullName("http://www.openarchives.org/OAI/2.0/", "record");
        OAI20_SET = fullName("http://www.openarchives.org/OAI/2.0/", "set");
        OAI20_METADATAFORMAT = fullName("http://www.openarchives.org/OAI/2.0/", "metadataFormat");
        OAI20_HEADER = fullName("http://www.openarchives.org/OAI/2.0/", "header");
        OAI20_ERROR = fullName("http://www.openarchives.org/OAI/2.0/", "error");
        OAI20_RESPONSE_DATE = fullName("http://www.openarchives.org/OAI/2.0/", "responseDate");
        OAI20_REQUEST_URL = fullName("http://www.openarchives.org/OAI/2.0/", "request");
        OAI20_RESUMPTION_TOKEN = fullName("http://www.openarchives.org/OAI/2.0/", "resumptionToken");
        OAI20_STATUS = fullName("http://www.openarchives.org/OAI/2.0/", "status");
        HarvesterVerb.INITIAL_BAOS_SIZE = 786432;
        HarvesterVerb.xmlReaders = new HashMap();
    }
}
